{*

--------------------------------------------
---------   Looking to make edits?   -------
--------------------------------------------

You can edit your template without editing this file directly.

For more information about editing your template please refer to our full documentation below:

https://www.zomex.com/docs/whmcs-templates/

Feel free to contact Zomex if you run into any issues or have any questions.

--------------------------------------------

*}

{include file="$template/includes/seo.tpl"} {* This line loads the functions for the SEO features *}

<meta charset="{$charset}" />

<!-- Styling -->
<link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600&display=swap" rel="stylesheet" />
<link href="{assetPath file='all.min.css'}?v={$versionHash}" rel="stylesheet" />
<link href="{assetPath file='theme.min.css'}?v={$versionHash}" rel="stylesheet" />
<link href="{$WEB_ROOT}/assets/css/fontawesome-all.min.css" rel="stylesheet" />

<script>
    var csrfToken = '{$token}',
        markdownGuide = '{lang|addslashes key="markdown.title"}',
        locale = '{if !empty($mdeLocale)}{$mdeLocale}{else}en{/if}',
        saved = '{lang|addslashes key="markdown.saved"}',
        saving = '{lang|addslashes key="markdown.saving"}',
        whmcsBaseUrl = "{\WHMCS\Utility\Environment\WebHelper::getBaseUrl()}",
        requiredText = '{lang|addslashes key="orderForm.required"}',
        recaptchaSiteKey = "{if $captcha}{$captcha->recaptcha->getSiteKey()}{/if}";
</script>
<script src="{assetPath file='scripts.min.js'}?v={$versionHash}"></script>

<link type="text/css" rel="stylesheet" href="{$WEB_ROOT}/templates/{$template}/css/layout.min.css" />

<link type="text/css" rel="stylesheet" href="{$WEB_ROOT}/templates/{$template}/css/whmcs.min.css" />
    
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

{if $templatefile eq "homepage"}

	{if $feature_slideshow eq "on" || $feature_slideshow eq "static"}

		<link rel="stylesheet" href="{$WEB_ROOT}/templates/{$template}/css/slider.min.css">
		<script src="{$WEB_ROOT}/templates/{$template}/js/slider.min.js"></script>	
		
		<script>
			$(document).ready(function(){
			$('.slideshow').bxSlider({
			
			auto: {if $feature_slideshow_auto eq "on"}true{else}false{/if},
			infiniteLoop: {if $feature_slideshow_infiniteloop eq "on"}true{else}false{/if},
			{if $feature_slideshow_pause}pause: {$feature_slideshow_pause},{/if}
			{if $feature_slideshow_speed}speed: {$feature_slideshow_speed},{/if}
			pager: {if $feature_slideshow_pager eq "on"}true{else}false{/if},
			adaptiveHeight: {if $feature_slideshow_adaptiveheight eq "on"}true{else}false{/if},
			
			touchEnabled: false,
			captions: false
			});
			});
		</script>	
	
	{/if}
	
{/if}

{if $templatefile eq "login" || $templatefile eq "clientregister"}{else}
	<script src="{$WEB_ROOT}/templates/{$template}/js/template.min.js"></script>
{/if}

{if $feature_animation eq "on"}
	<link type="text/css" rel="stylesheet" href="{$WEB_ROOT}/templates/{$template}/css/animate.min.css" />
	<script src="{$WEB_ROOT}/templates/{$template}/js/wow.min.js"></script>
	<script>
		new WOW({
		
			mobile: false	
			
		}).init();
	</script>	
{/if}
    
{if $multilanguagesupport eq "google"}
	{literal}
		<script>
		function googleTranslateElementInit() {
		new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
		}
		</script>
	{/literal}
	<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
{/if}

{if $feature_stickymenu eq "off" || $templatefile == "store/weebly/index" || $templatefile == "store/ssl/dv" || $templatefile == "store/ssl/ov" || $templatefile == "store/ssl/ev" || $templatefile == "store/ssl/wildcard" || $templatefile == "store/cpanelseo/index" || $templatefile eq "login" || $filename eq "register" || $templatefile eq "clientareasecurity"}{else}
	<script>
	jQuery(function($) { $(document).ready( function() {
		
		$('.navmain-container').stickUp(); });
	});
	</script>
{/if}

{include file="$template/includes/css.tpl"} {* This line loads the CSS functions *}

{if $LANG.textdirection eq "rtl"}
	<link type="text/css" rel="stylesheet" href="{$WEB_ROOT}/templates/{$template}/css/rtl.min.css" />
{/if}

{assetExists file="custom.css"}
	<link href="{$__assetPath__}" rel="stylesheet">
{/assetExists}

{if $feature_favicon_url}
	<link rel="shortcut icon" href="{$feature_favicon_url}" />
{/if}